/*
 * Decompiled with CFR 0.152.
 */
package tech.kongolian.PasswordManagerCLI;

import java.util.Scanner;
import tech.kongolian.PasswordManagerCLI.Encryption.Encoder;
import tech.kongolian.PasswordManagerCLI.Format.ColourFormat;
import tech.kongolian.PasswordManagerCLI.ManagePasswords;
import tech.kongolian.PasswordManagerCLI.PasswordGenerator;
import tech.kongolian.PasswordManagerCLI.SavePasswords;
import tech.kongolian.PasswordManagerCLI.lowDB.low;

public class Main {
    public static String Password;
    public static String usage;
    public static ColourFormat cf;
    protected static low pm;

    public static void main(String[] args) {
        System.out.println(cf.ANSI_GREEN(cf.ANSI_GREEN("  ____       _      ____    ____   __        __   ___    ____    ____  \n |  _ \\     / \\    / ___|  / ___|  \\ \\      / /  / _ \\  |  _ \\  |  _ \\ \n | |_) |   / _ \\   \\___ \\  \\___ \\   \\ \\ /\\ / /  | | | | | |_) | | | | |\n |  __/   / ___ \\   ___) |  ___) |   \\ V  V /   | |_| | |  _ <  | |_| |\n |_|     /_/   \\_\\ |____/  |____/     \\_/\\_/     \\___/  |_| \\_\\ |____/ \n                                                                       ")));
        System.out.println(cf.ANSI_YELLOW("                                                  Generator / Manager "));
        System.out.println(cf.ANSI_YELLOW("                                                  Made by: Zeeshan\n\n\n"));
        System.out.println(cf.ANSI_BLUE("Usage: java -jar PasswordGenerator.jar\n"));
        while (true) {
            System.out.println(cf.ANSI_BLUE("Welcome To the Password Generator / Manager! \nPlease choose an option!"));
            low.initializeMap();
            Main.choiceOptions();
            Main.cleanConsole();
        }
    }

    public static void choiceOptions() {
        System.out.println(cf.ANSI_PURPLE("Options:  "));
        System.out.println(cf.ANSI_PURPLE("1. Generate a new password"));
        System.out.println(cf.ANSI_PURPLE("2. Manage your passwords"));
        System.out.println(cf.ANSI_BRIGHT_RED("3. Exit"));
        Scanner scanner = new Scanner(System.in);
        try {
            int choice = scanner.nextInt();
            switch (choice) {
                case 1: {
                    System.out.println(cf.ANSI_CYAN("Selected to Generate a new password!"));
                    Main.Choice1_GeneratePassword();
                    return;
                }
                case 2: {
                    System.out.println(cf.ANSI_CYAN("Selected to manage passwords"));
                    Main.Choice2_ManagePassword();
                    return;
                }
                case 3: {
                    System.out.println(cf.ANSI_BRIGHT_RED("Exiting"));
                    System.exit(0);
                    return;
                }
            }
            System.out.println(cf.ANSI_BRIGHT_RED("Invalid choice! (Make sure you're using the correct number)  "));
            Main.choiceOptions();
        }
        catch (Exception e) {
            System.out.println(cf.ANSI_BRIGHT_RED("Invalid choice! (Make sure you're using numbers) "));
            Main.choiceOptions();
        }
    }

    public static void Choice1_GeneratePassword() {
        Main.cleanConsole();
        Scanner scanner = new Scanner(System.in);
        do {
            System.out.println(cf.ANSI_CYAN("What platform is the password going to be used for?") + cf.ANSI_PURPLE(" facebook, netflix, instagram? "));
            usage = scanner.nextLine();
            usage = usage.toLowerCase();
            if (!usage.equals("") && usage != null) continue;
            System.out.println(cf.ANSI_BRIGHT_RED("Please enter a valid platform"));
        } while (usage == null || usage.equals(""));
        Main.keyValidation();
        System.out.println(cf.ANSI_CYAN("How many characters do you want your password to be? "));
        int passwordLength = scanner.nextInt();
        while (passwordLength < 3 || passwordLength > 50) {
            System.out.println(cf.ANSI_RED("Your password must be between 3 - 50 characters long. Please enter a new password length."));
            passwordLength = scanner.nextInt();
        }
        System.out.println(cf.ANSI_CYAN("What type of password do you want to generate?\n1. Lowercase\n2. Uppercase\n3. Numeric\n4. Lowercase and Uppercase\n5. Lowercase, Uppercase, and Numeric\n6. Lowercase, Uppercase, Numeric, and Special Characters"));
        int passwordType = scanner.nextInt();
        while (passwordType < 1 || passwordType > 6) {
            System.out.println(cf.ANSI_BRIGHT_RED("You must enter a valid password type. Please enter a new password type."));
            passwordType = scanner.nextInt();
        }
        PasswordGenerator passwordGenerator = new PasswordGenerator(passwordLength, passwordType);
        Password = passwordGenerator.GeneratePassword();
        System.out.println(cf.ANSI_GREEN("Your password is: ") + Password);
        System.out.println(cf.ANSI_CYAN("Do you want to Re-Roll the password? (y/n)"));
        while (true) {
            String likePassword = scanner.nextLine();
            if ((likePassword = likePassword.toLowerCase()).equals("n")) {
                String EncPass = Encoder.encode(Password);
                SavePasswords sp = new SavePasswords(EncPass, usage);
                sp.savePassword();
                System.out.println(cf.ANSI_GREEN("Your password has been saved! "));
                System.out.println(cf.ANSI_BOLD("Press enter to continue..."));
                scanner.nextLine();
                break;
            }
            if (likePassword.equals("y")) {
                Password = passwordGenerator.GeneratePassword();
                System.out.println(cf.ANSI_GREEN("Your new password is: ") + Password);
                System.out.println(cf.ANSI_CYAN("Do you want to Re-Roll the password? (y/n)"));
                if (!likePassword.equals("n")) continue;
                String EncPass = Encoder.encode(Password);
                SavePasswords sp = new SavePasswords(EncPass, usage);
                sp.savePassword();
                System.out.println(cf.ANSI_GREEN("Your password has been saved! "));
                System.out.println(cf.ANSI_BOLD("Press enter to continue..."));
                scanner.nextLine();
                break;
            }
            if (likePassword == null || likePassword.length() <= 0) continue;
            System.out.println(cf.ANSI_RED("Invalid choice! (Make sure you're using y or n)"));
        }
    }

    public static void Choice2_ManagePassword() {
        ManagePasswords mp = new ManagePasswords();
        Main.cleanConsole();
        mp.passManager();
    }

    public static void cleanConsole() {
        for (int i = 0; i < 50; ++i) {
            System.out.println();
        }
    }

    public static void keyValidation() {
        Scanner scanner = new Scanner(System.in);
        if (pm.containsKey(usage)) {
            String overwrite;
            System.out.println(cf.ANSI_BRIGHT_RED("This platform already exists in the database! "));
            do {
                System.out.println(cf.ANSI_BRIGHT_RED("Would you like to overwrite it? (y/n)"));
                overwrite = scanner.nextLine();
                overwrite = overwrite.toLowerCase();
                if (overwrite.equals("y")) {
                    System.out.println(cf.ANSI_CYAN("Overwriting the password for " + usage + "!"));
                    pm.remove(usage);
                    continue;
                }
                if (overwrite.equals("n")) {
                    do {
                        usage = "";
                        System.out.println(cf.ANSI_CYAN("Please enter valid Platform?") + cf.ANSI_PURPLE(" facebook, netflix, instagram? "));
                        usage = scanner.nextLine();
                        usage = usage.toLowerCase();
                        Main.keyValidation();
                    } while (usage == null || usage.equals(""));
                    continue;
                }
                System.out.println(cf.ANSI_BRIGHT_RED("Please enter a valid option"));
            } while (overwrite.equals(null) || overwrite.equals(""));
        }
    }

    static {
        cf = new ColourFormat();
        pm = new low();
    }
}

